/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.furniture;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import technology.rocketjump.undermount.assets.TextureAtlasRepository;
import technology.rocketjump.undermount.assets.entities.furniture.FurnitureEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.furniture.model.FurnitureEntityAsset;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetDictionaryProvider;
import technology.rocketjump.undermount.assets.entities.model.SpriteDescriptor;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureCategoryDictionary;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureLayoutDictionary;
import technology.rocketjump.undermount.rendering.RenderMode;

public class FurnitureEntityAssetDictionaryProvider
implements Provider<FurnitureEntityAssetDictionary> {
    private final TextureAtlasRepository textureAtlasRepository;
    private final FurnitureCategoryDictionary categoryDictionary;
    private final FurnitureLayoutDictionary layoutDictionary;

    @Inject
    public FurnitureEntityAssetDictionaryProvider(TextureAtlasRepository textureAtlasRepository, FurnitureCategoryDictionary categoryDictionary, FurnitureLayoutDictionary layoutDictionary) {
        this.textureAtlasRepository = textureAtlasRepository;
        this.categoryDictionary = categoryDictionary;
        this.layoutDictionary = layoutDictionary;
    }

    @Override
    public FurnitureEntityAssetDictionary get() {
        TextureAtlas diffuseTextureAtlas = this.textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.DIFFUSE_ENTITIES);
        TextureAtlas normalTextureAtlas = this.textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.NORMAL_ENTITIES);
        FileHandle entityDefinitionsFile = Gdx.files.internal("assets/definitions/entityAssets/furnitureEntityAssets.json");
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            List assetList = (List)objectMapper.readValue(entityDefinitionsFile.readString(), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, FurnitureEntityAsset.class));
            for (FurnitureEntityAsset asset : assetList) {
                for (SpriteDescriptor spriteDescriptor : asset.getSpriteDescriptors().values()) {
                    if (spriteDescriptor.getIsAnimated()) {
                        HumanoidEntityAssetDictionaryProvider.addAnimatedSpriteArray(spriteDescriptor, diffuseTextureAtlas, RenderMode.DIFFUSE);
                        HumanoidEntityAssetDictionaryProvider.addAnimatedSpriteArray(spriteDescriptor, normalTextureAtlas, RenderMode.NORMALS);
                        continue;
                    }
                    HumanoidEntityAssetDictionaryProvider.addSprite(spriteDescriptor, diffuseTextureAtlas, RenderMode.DIFFUSE);
                    HumanoidEntityAssetDictionaryProvider.addSprite(spriteDescriptor, normalTextureAtlas, RenderMode.NORMALS);
                }
            }
            return new FurnitureEntityAssetDictionary(assetList, this.categoryDictionary, this.layoutDictionary);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

